package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.network.Handler16UpdateGenes;

public interface IModifiable {
	
	public int getGeneStrength(Gene gene);

	public void setGene(Gene gene, int level);
	
	public boolean removeGene(Gene gene);
	
	public boolean hasGene(Gene gene);

	public GenePool getGenePool();
	
	public void setGeneScaling(float scale);
	
	public float getGeneScaling();
	
	public float getBaseXSize();
	
	public float getBaseYSize();
	
	public float getBaseYOffset();
	
	public float getBaseStepHeight();
	
	public boolean shouldApplySizeChange();
}
